<?php
/**
 * Template part for top panel in header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Johnnygo
 */

// Don't show top panel if all elements are disabled.
if ( ! johnnygo_is_top_panel_visible() ) {
	return;
}
?>

<div <?php echo johnnygo_get_html_attr_class( array( 'top-panel' ), 'top_panel_bg' ); ?>>
	<div class="container">
		<div class="top-panel__container">
			<?php johnnygo_top_message( '<div class="top-panel__message">%s</div>' ); ?>
			<?php johnnygo_contact_block( 'header_top_panel' ); ?>

			<div class="top-panel__wrap-items">
				<div class="top-panel__menus">
					<?php johnnygo_top_menu(); ?>
					<?php johnnygo_login_link(); ?>
					<?php johnnygo_header_woo_currency_switcher(); ?>
					<?php johnnygo_social_list( 'header' ); ?>
				</div>
			</div>
		</div>
	</div>
</div><!-- .top-panel -->
