<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package mise
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
		$showReadMore = mise_options('_readmore_button', '');
		$readMoreText = mise_options('_readmore_text', __( 'Read More', 'mise' ));
	?>
	<?php
		if ( '' != get_the_post_thumbnail() ) {
			echo '<div class="entry-featuredImg">';
			if ( ! is_active_sidebar( 'sidebar-classic' ) ) {
				the_post_thumbnail('large');
			} else {
				the_post_thumbnail('mise-little-post');
			}
			echo '<div class="insideImage"><span><a href="' .esc_url(get_permalink()). '">'.esc_html($readMoreText).'<i class="spaceLeft fa fa-angle-right" aria-hidden="true"></i></a></span></div></div>';
		}
	?>
	<div class="entry-theContent">
		<header class="entry-header">
			<?php mise_entry_category(); ?>
			<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
			<?php if ( 'post' === get_post_type() ) : ?>
			<div class="entry-meta">
				<?php mise_posted_on(); ?>
			</div><!-- .entry-meta -->
			<?php
			endif; ?>
		</header><!-- .entry-header -->

		<div class="entry-summary">
			<?php the_excerpt(); ?>
			<?php if ($showReadMore == 1): ?>
				<div class="miseButton">
					<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($readMoreText); ?></a>
				</div>
			<?php endif; ?>
		</div><!-- .entry-content -->
	
		<footer class="entry-footer">
			<?php
				edit_post_link(
					sprintf(
						/* translators: %s: Name of current post */
						esc_html__( 'Edit %s', 'mise' ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					),
					'<span class="edit-link"><i class="fa fa-wrench spaceRight" aria-hidden="true"></i>',
					'</span>'
				);
			?>
		</footer><!-- .entry-footer -->
	</div>
</article><!-- #post-## -->
